#!%perl%

#########################################################
#            AVSMaker Professional Edition              #
#     Written entirely by Dan Jones (sf@termina.com)    #
#########################################################
#                                                       #
#                                                       #
# This script was created by:                           #
#                                                       #
# PerlCoders Web Specialties PTY.                       #
# http://www.perlcoders.com                             #
#                                                       #
# This script and all included modules, lists or        #
# images, documentation are copyright only to           #
# PerlCoders PTY (http://perlcoders.com) unless         #
# otherwise stated in the module.                       #
#                                                       #
# Purchasers are granted rights to use this script      #
# on any site they own. There is no individual site     #
# license needed per site.                              #
#                                                       #
# Any copying, distribution, modification with          #
# intent to distribute as new code will result          #
# in immediate loss of your rights to use this          #
# program as well as possible legal action.             #
#                                                       #
# This and many other fine scripts are available at     #
# the above website or by emailing the authors at       #
# staff@perlcoders.com or info@perlcoders.com           #
#                                                       #
#                                                       #
#########################################################






#----------------------! do not edit below this line !-----------------------


use strict;
use vars qw(%cf %cgi %mysql %used @cats);
my (
	@templates,
	@corefuncs,
	$inited,
	%opts,
);


# Include required modules
foreach ("http", "routines") {
	eval { require ("$_.pl") };
	print "Content-type: text/plain\n\n".
		"Could not include $_.pl\n($@)\n" and exit
		if $@;
}

# Initialise global variables and set to default values and read settings
# from configuration tables

initvars();
readconf();


# Grab the (optional) "action" CGI parameter
getcgi("action");

if (!$cgi{action}) {
	# No action has been passed to the script, so the presence of
	# registration data is checked.

	my $ac = dosql(qq[select username from ap_users limit 1]);
	if ($ac->rows) {
		prthtml("login");
	} else {
		# Script has not yet been registered. Find paths of required
		# utilities if available and print registration HTML.
	
		foreach ("/usr/bin", "/usr/local/bin") {
			$ENV{PATH} .= ":$_" if $ENV{PATH} !~ /$_/;
		}
		foreach ("cjpeg", "djpeg", "pnmscale") {
			chomp (($cf{$_}) = grep { /^\// } `which $_`);
		}
		prthtml("register");
	}
	# Terminate program as no further processing is required.
	
	exit;
}

# Check that action is valid, and ensure the current user's authentication
# level is high enough to execute the action according to the administrative
# settings.

my $ac = dosql(qq[select permlevel from ap_actions where action="$cgi{action}"]);
err("Invalid action: $cgi{action}") if !$ac->rows;
checksession(($ac->fetchrow_array)[0]);


if ($cgi{action} eq "login") {
	# User is logging in.

	getcgi({
		username	=> "Username",
		password	=> "Password",
	});
	my $ac = dosql(qq[select *,date_format(lasttime, "%H:%i on %d %b %Y") as lt from ap_users where username="$cgi{username}"]);
	prthtml("authfailed"), exit if (!$ac->rows);	# No such user
	my $row = $ac->fetchrow_hashref;
	
	my $salt = ($$row{password} =~ /^\$/ ? (split(/\$/, $$row{password}))[2] : substr($$row{password}, 0, 2));

	if (substr($$row{password}, 0, 13) ne substr(crypt($cgi{password}, $salt), 0, 13)) {
		# User exists but password is incorrect.
		prthtml("authfailed");
	} else {
		# User exists and password is OK; log in by placing cookie on
		# client machine and update last login time and IP address in the
		# "data" table.

		setcookie("avspro=$$row{uid}+$$row{password}");
		dosql(qq[update ap_users set lasttime = now(), lastip = "$ENV{REMOTE_ADDR}" where uid = $$row{uid}]);
		$cf{done} = "Last login: $$row{lt} from $$row{lastip}" if $$row{lastip};
		printindex();
	}
}
elsif ($cgi{action} eq "register") {
	# Processing script registration.

	my $ac = dosql(qq[select count(*) from ap_users]);
	err("Data already exists in database, a previous install exists on this machine. Change MySQL database or use existing installation.") if ($ac->fetchrow_array)[0] > 0;

	# Retrieve all required and option CGI fields.
	getcgi({
		username	=> "Admin username",
		password	=> "Password",
		confirm		=> "Confirmation pass",
		email		=> "Email address",
		
		chname		=> "Christian name",
		surname		=> "Surname",
		addr1		=> "Address 1",
		city		=> "City",
		state		=> "State",
		zip		=> "Zipcode",
		country		=> "Country",
		phone		=> "Phone Number",
		defpass		=> "Default pass",

		domain		=> "Initial domain",
		dpath		=> "Initial domain path",		
		imagepath	=> "Initial image path",
		hubname		=> "Main linksite name",
		hubpath		=> "Main linksite path",
		huburl		=> "Main linksite URL",
		
		cjpeg		=> "Path to cjpeg; contact your system administrator or support\@avsmakerpro.com.",
		djpeg		=> "Path do djpeg; contact your system administrator or support\@avsmakerpro.com.",
		pnmscale	=> "Path do pnmscale; contact your system administrator or support\@avsmakerpro.com.",
		},
		"addr2",
		"fax",
	);

	err("Invalid username, can only contain alphanumeric characters, underscore and hyphen")
		if $cgi{username} =~ /[^\w-]/ or
		length($cgi{username}) > 10;
	err("Passwords do not match") if $cgi{password} ne $cgi{confirm};
	err("Password too short, please ensure it is at least 8 characters")
		if length($cgi{password}) < 8;
	err("Invalid email") if ($cgi{email} !~ /\w+\@[\w-]+\.\w+/);
	foreach ("cjpeg", "djpeg", "pnmscale") {
		err("Bad path to $_") if !-x $cgi{$_};
	}

	map { s/^\w+\:\/\/// } @cgi{"domain", "lsurl"};
	map { s/\/+$// } @cgi{"domain", "dpath", "imagepath", "lspath", "lsurl"};
	map { $_ .= "/index.html" } @cgi{"lspath", "lsurl"};

	# Check sendmail location	
	foreach (qw(/usr/sbin/sendmail /usr/bin/sendmail /usr/lib/sendmail /var/qmail/bin/sendmail)) {
		$cf{sendmail} = $_, last if ($cf{sendmail} || -x $_);
	}
	err("Could not find sendmail, please specify in admin.cgi")
		if !$cf{sendmail};

	# Create DES hash of password.
	$cgi{hash} = hash($cgi{password});

	# Recursively create image path directory
	mkdir_r($cgi{imagepath}) if !-d $cgi{imagepath};

	my $success = gethttp({
		host	=> "http://perlcoders.com",
		file	=> "/apupdates/add_AVSPro_user.cgi",
		params	=> "$cgi{email}&$cgi{password}",
		pat	=> "(done|add|failed|upgrade)",
	}) or err(qq[Could not process registration, please email <a href="$cf{cgiurl}?action=support">support\@avsmakerpro.com</a>.]);

	if ($success eq "upgrade") {
		# Script license is insufficient and must be upgraded.
		err(	qq[This copy of AVSMaker Professional is only licensed for one installation.<p>\n].
			qq[To enhance your license to allow for multiple installations at no extra charge, please email <a href="$cf{cgiurl}?action=support">support\@avsmakerpro.com</a>.<p>\n].
			qq[If an error occurred and this is a re-install, please email us with the details and we will assist you as soon as possible.]);
	} elsif ($success eq "failed") {
		# Unknown error
		err(qq[Registration failed for unknown reason. Please mail <a href="$cf{cgiurl}?action=support">support\@avsmakerpro.com</a>.]);
	}
	
	dosql(qq[insert into ap_users values ("", "$cgi{username}", "$cgi{hash}", "", "")]);
	(my $searchurl = $cf{cgiurl}) =~ s/admin.cgi$/search.cgi/;
	dosql(qq[insert into ap_data values (].
		join("", map { qq["$cgi{$_}", ] } qw[
				chname
				surname
				email
				password
				addr1
				addr2
				city
				state
				zip
				country
				phone
				fax
				defpass
				imagepath
				cjpeg
				djpeg
				pnmscale
			]).
		qq[171, 0, 0, 1, 1, 1, 1, 1, 1, 1, 3, 4, 3, 128, 96, 50, 14, "$searchurl", "")]);
	dosql(qq[insert into ap_domains values("$cgi{domain}", "", "$cgi{dpath}")]);
	dosql(qq[insert into ap_linksites values("", "$cgi{hubname}", "$cgi{hubpath}", "$cgi{huburl}", "", "")]);

	# Execute avspro.pl with "-u" flag to update script to the very latest
	# version.
	qx($cf{datapath}/avspro.pl -u);

	# Send an e-mail to AVSMakerPro.com with script installation and personal
	# data, to complete the registration process.
		
	# This information is sent for two purposes;
	#   - theft prevention, to ensure our commercial projects are not
	#     distributed illegally and without our consent
	#   - support; server information greatly aids us in installing and
	#     troubleshooting problems
	
	open (D, "| $cf{sendmail} -t")
		or err("Could not send email to register!");
	
	my $time = localtime()."";
	my $sysinf = `uname -a` || $^O || "Unknown";
	my $reg = ($success =~ /done/ ? "Registration" : "Additional installation by user $cgi{email}");
	$cgi{addr2} = "\n          $cgi{addr2}"	if $cgi{addr2};
	$cgi{fax} = "\nFax     - $cgi{fax}" 	if $cgi{fax};

	print D <<EOF;
To: support\@avsmakerpro.com
Cc: avspro\@termina.com
Subject: [avspro] AVSMakerPro Registration
From: $cgi{email}

$reg received at $time

Server/Electronic Information
Email  - $cgi{email}
Domain - $cgi{domain}
File   - $ENV{REQUEST_URI}
Host   - $ENV{HTTP_HOST}, $ENV{SERVER_NAME} ($ENV{SERVER_ADDR})
System - $sysinf
Perl   - $]
Server - $ENV{SERVER_SOFTWARE}
Admin  - $ENV{SERVER_ADMIN}
Remote - $ENV{REMOTE_ADDR}
Agent  - $ENV{HTTP_USER_AGENT}
Links  - $cgi{huburl}

Personal Information
Name    - $cgi{chname} $cgi{surname}
Address	- $cgi{addr1}$cgi{addr2}
          $cgi{city}
          $cgi{state}
          $cgi{zip}
          $cgi{country}
Phone   - $cgi{phone}$cgi{fax}
EOF
	close D;
	
	# Everything's completed successfully; print login HTML for administrator
	# to log in for the first time and begin using the script.

	$cf{done} = "Successfully registered!";
	prthtml("login");
}
elsif ($cgi{action} eq "index") {
	# Print admin index.

	printindex();
}
elsif ($cgi{action} eq "sitegen") {
	# Generate a site, with user input
	
	$cf{catselect} = catselect();
	$cf{avsselect} = avsselect();
	$cf{usefreehosts} = ($cf{usefreehosts} ? "checked" : "");
	$cf{layoutselect} = qq[\t\t<option value="">Random\n];
	my $ac = dosql(qq[select name from ap_layouts]);
	$cf{layoutselect} .= qq[\t\t<option value="$_">$_\n]
		while $_ = ($ac->fetchrow_array)[0];
	prthtml("sitegen");
}
elsif ($cgi{action} eq "createsite" || $cgi{action} eq "quickgen") {
	getcgi(
		"cat",
		"sitename",
		"descr",
		"keywords",
		"layout",
		"avs_1",
		"avs_2",
		"avs_3",
		"avs_4",
		"avs_5",
		"testsite",
		"usefreehosts",
		"gll",
	);
	my $params;
	$params .= qq[ -c "$cgi{cat}"] 		if $cgi{cat};
	$params .= qq[ -t "$cgi{sitename}"] 	if $cgi{sitename};
	$params .= qq[ -k "$cgi{keywords}"]	if $cgi{keywords};
	$params .= qq[ -l "$cgi{layout}"]	if $cgi{layout};
	my $avss = join(",", grep { /\w/ } map { $cgi{"avs_$_"} } 1..5);
	$avss =~ s/,{2,}/,/g;
	$params .= qq[ -m $avss]		if $avss;
	$params .= qq[ -n]			if $cgi{testsite};
	$params .= ($cgi{usefreehosts} ? qq[ -f] : qq[ -x]);
	$params .= qq[ -g]			if $cgi{gls};
	$params =~ s/^\s+//;
	my $pid = "$$.".time();
	$cf{meta} = qq[\n<meta http-equiv="refresh" content="5; url=$cf{cgiurl}?action=progress&pid=$pid">];
	$cf{prog} = "Launching AVSMaker Professional...";
	prthtml("createsite/head");
	print "<b>Now executing.. please wait</b><br>";
	prthtml("createsite/foot");
	$| = 1;
	if (fork() == 0) {
#		POSIX::setsid();
		$| = 1;
		close(STDIN); close(STDOUT); close(STDERR);
		exec("./avspro.pl -w -v $params > $cf{tmppath}/$pid.dat");
		exit;
	}
	exit;
}
elsif ($cgi{action} eq "progress") {
	getcgi({
		pid	=> "ID of process",
	});
	open (F, "< $cf{tmppath}/$cgi{pid}.dat")
		or err("Could not open progress file");
	my @output = <F>;
	close F;
	if ($output[$#output] ne ".\n") {
		$cf{meta} = qq[\n<meta http-equiv="refresh" content="10; url=$cf{cgiurl}?action=progress&pid=$cgi{pid}">];
		$cf{prog} = "AVSMaker Professional is currently executing, please wait!";
	} else {
		pop(@output);
		$cf{meta} = "";
		$cf{prog} = "Execution complete";
		unlink "$cf{tmppath}/$cgi{pid}.dat";
	}
	prthtml("createsite/head");
	$output[0] = "<b>$output[0]</b>";
	foreach (@output) {
		study $_;
		s!(http:\/\/[^\s\)]+)!<a href="$1">$1</a>!g;
		s!^(\w)!<br>$1!;
		s!^ -!<b> -! && s!$!</b>!;
		s!(ERROR|WARNING)!<font color=red><b>$1</b></font>!;
		s!\n!<br>\n!;
		print "\t\t$_";
	}
	prthtml("createsite/foot");
}
elsif ($cgi{action} eq "refreshimgqueue") {
	qx(./avspro.pl -qr);
	$cf{done} = "Image queue refreshed successfully";
	printindex();
}
elsif ($cgi{action} eq "selectscheme") {
	selectscheme();
}
elsif ($cgi{action} eq "editschemes") {
	getcgi("scheme");
	$cgi{scheme} ||= "";
	schemeindex();
}
elsif ($cgi{action} eq "writescheme") {
	getcgi(
		{ scheme	=> "Scheme name" },
		(map { "cat_$_" } 1..5),
		"bodytags",
		"tabletags",
		"tdtags",
		"fonttags",
		"logofg",
		"logobg",
	);
	err("Scheme name can only contain alphanumeric characters, dash and underscore")
		if $cgi{scheme} =~ /[^\w-]/;
	err("Invalid logo colors") if ($cgi{logofg} and $cgi{logofg} !~ /^[a-zA-Z90-9]{6}$/)
		|| ($cgi{logobg} and $cgi{logobg} !~ /^[a-zA-Z90-9]{6}$/);
	my $cats = join(" ", map { $cgi{"cat_$_"} } 1..5);
	$cats =~ s/\s+/ /g; $cats =~ s/^\s+//; $cats =~ s/\s+$//;
	dosql(qq[replace into ap_schemes values("$cgi{scheme}", "$cats")]);
	foreach my $tag ("bodytags", "tabletags", "tdtags", "fonttags") {
		my @tags = split(/[\n\r]+/, $cgi{"$tag"});
		foreach (@tags) {
			err(qq[Tag "$_" too long, must be 100 characters or less])
				if length($_) > 100;
		}
		dosql(qq[delete from ap_$tag where scheme = "$cgi{scheme}"]);
		dosql("insert into ap_$tag values " .
			join(",", map { qq[("$_", "$cgi{scheme}")] } @tags));
	}
	dosql(qq[delete from ap_logogen where scheme="$cgi{scheme}"]);
	dosql(qq[insert into ap_logogen values("$cgi{logofg}", "$cgi{logobg}", "$cgi{scheme}")])
		if $cgi{logofg} || $cgi{logobg};
	$cf{done} = "Scheme ".uc($cgi{scheme})." saved successfully";
	selectscheme();
}
elsif ($cgi{action} eq "delscheme") {
	getcgi({
		scheme	=> "Scheme to delete",
	});
	my $ac = dosql(qq[delete from ap_schemes where name="$cgi{scheme}"]);
	err("No such scheme: $cgi{scheme}") if !$ac->rows;
	foreach my $tag ("bodytags", "tabletags", "tdtags", "fonttags", "js", "css", "custtag1", "custtag2", "custtag3") {
		dosql(qq[delete from ap_$tag where scheme = "$cgi{scheme}"]);
	}
	$cf{done} = "Scheme ".uc($cgi{scheme})." deleted successfully";
	selectscheme();
}
elsif ($cgi{action} eq "editptags") {
	getcgi({
		scheme	=> "Scheme name. Ensure scheme is saved before editing these tags.",
		type	=> "Tag type",
	});

	prthtml("editptags/head");
	$cf{num} = 0;

	my $ac = dosql(qq[select tag from ap_$cgi{type} where scheme="$cgi{scheme}"]);
	while ($cf{tag} = ($ac->fetchrow_array)[0]) {
		$cf{num}++;
		prthtml("editptags/item");
	}

	foreach (1..4) {
		$cf{num}++;
		prthtml("editptags/item");
	}

	prthtml("editptags/foot");
}
elsif ($cgi{action} eq "writeptags") {
	getcgi({
		scheme	=> "Scheme name",
		type	=> "Tag type",
		numtags	=> "Number of tags",
		next	=> "Next action",
	});
	
	dosql(qq[delete from ap_$cgi{type} where scheme="$cgi{scheme}"]);
	getcgi(map { "tag_$_" } 1..$cgi{numtags});
	foreach my $n (1..$cgi{numtags}) {
		next if !$cgi{"tag_$n"};
	}

	dosql(
		qq[insert into ap_$cgi{type} values].
		join(", ", map { "(\"$_\", \"$cgi{scheme}\")" }
			grep(/\w/, map { $cgi{"tag_$_"} } 1..$cgi{numtags}))
	);
	
	$cf{done} = "Tags updated successfully";
	if ($cgi{next} =~ /^add/i) {
		redir("editptags&scheme=$cgi{scheme}&type=$cgi{type}");
	} else {
		schemeindex();
	}	                                                
}
elsif ($cgi{action} eq "editlayouts") {
	layoutindex();
}
elsif ($cgi{action} eq "editpagetypes") {
	my $ac = dosql(qq[select name from ap_pagetypes]);
	$cf{pagetypes} = "";
	$cf{pagetypes} .= "$_\n"
		while $_ = ($ac->fetchrow_array)[0];
	prthtml("editpagetypes");
}
elsif ($cgi{action} eq "writepagetypes") {
	getcgi({
		pagetypes	=> "Page types",
		source		=> "Source of request",
	});
	my @pagetypes = split(/[\n\r]+/, $cgi{"pagetypes"});
	my $ac = dosql(qq[select id from ap_avs]);
	my @avs;
	push (@avs, $_) while $_ = ($ac->fetchrow_array)[0];
	foreach my $pt (@pagetypes) {
		err(qq[Type name "$pt" too long, must be 20 letters or less])
			if length($pt) > 20;
		err("Page types must only contain alphanumeric characters, use underscore instead of spaces")
			if $pt =~ /[^\w-]/;
		foreach (@avs) {
			mkdir_r("$cf{datapath}/templates/$pt/$_");
		}
	}
	dosql(qq[delete from ap_pagetypes]);
	dosql(qq[insert into ap_pagetypes values].
		join(", ", map { "(\"$_\")" } @pagetypes));
	$cf{done} = "Updated page types successfully";
	if ($cgi{source} eq "tmpl") {
		selecttemplatetype();
	} else {
		layoutindex();
	}
}
elsif ($cgi{action} eq "editstructures") {
	getcgi("layout");
	my (
		%ldata,
		@pagetypes,
	);
	if ($cgi{layout}) {
		my $ac = dosql(qq[select * from ap_layouts where name="$cgi{layout}"]);
		err("Invalid layout: $cgi{layout}") if !$ac->rows;
		%ldata = %{$ac->fetchrow_hashref};
	} else {
		$cf{layout} = "";
	}
	my @ccats = split(/ /, $ldata{cats});
	foreach (1..5) {
		$cf{"catselect_$_"} = catselect(shift @ccats);
	}
	my @avs = split(/ /, $ldata{avss});
	foreach (1..5) {
		$cf{"avsselect_$_"} = avsselect(shift @avs);
	}
	my $ac = dosql(qq[select name from ap_schemes]);
	$cf{schemeselect} = qq[\t\t<option value="">Random\n];
	while (my $row = $ac->fetchrow_hashref) {
		$cf{schemeselect} .= qq[\t\t<option value="$$row{name}"].
			($ldata{scheme} eq $$row{name} ? " selected" : "").
			qq[>$$row{name}\n];
	}
	
	$ac = dosql(qq[select name from ap_pagetypes]);
	push (@pagetypes, $_) while $_ = ($ac->fetchrow_array)[0];

	map { $cf{"tour$_"} = ptselect($ldata{"tour$_"}) } 1..6;
	map { $cf{"cont$_"} = ptselect($ldata{"cont$_"}) } 1..15;
	
	prthtml("editlayouts/edit");
	
	sub	ptselect {
		my $options = qq[\t\t<option value="">-\n];
		my $selected = shift(@_);
		foreach my $pt (@pagetypes) {
			$options .= qq[\t\t<option value="$pt"].
				($pt eq $selected ? " selected" : "").
				qq[>$pt\n];
		}
		return $options;
	}
}
elsif ($cgi{action} eq "dellayout") {
	getcgi({
		layout	=> "Layout name",
	});
	my $ac = dosql(qq[delete from ap_layouts where name="$cgi{layout}"]);
	err("No such layout: $cgi{layout}") if !$ac->rows;
	$cf{done} = "Layout ".uc($cgi{layout})." deleted successfully";
	layoutindex();
}
elsif ($cgi{action} eq "writestructure") {
	getcgi(
		{ layout => "Layout name" },
		(map { "cat_$_" } 1..5),
		(map { "avs_$_" } 1..5),
		"scheme",
		(map { "tour$_" } 1..6),
		(map { "cont$_" } 1..15),
	);

	err("Name can only contain alphanumeric characters, dash and underscore")
		if $cgi{layout} =~ /[^\w-]/;	
	err("At least 1 tour and content page must be specified")
		if (!$cgi{tour1} || !$cgi{cont1});
	my $cats = join(" ", map { $cgi{"cat_$_"} } 1..5);
	$cats =~ s/\s+/ /g; $cats =~ s/^\s+//; $cats =~ s/\s+$//;
	my $avss = join(" ", map { $cgi{"avs_$_"} } 1..5);
	$avss =~ s/\s+/ /g; $avss =~ s/^\s+//; $avss =~ s/\s+$//;

	dosql(
		qq[replace into ap_layouts values("$cgi{layout}", "$cats", ] .
		qq["$avss", "", "$cgi{scheme}", ] .
		join("", (map { '"' . $cgi{"tour$_"} . '", ' } 1..6)) .
		join(",", (map { '"' . $cgi{"cont$_"} . '"' } 1..15)) .
		qq[)]
	);
	$cf{done} = "Saved site structure successfully";
	layoutindex();
}
elsif ($cgi{action} eq "selecttemplatetype") {
	selecttemplatetype();
}
elsif ($cgi{action} eq "selecttemplate") {
	getcgi({
		type	=> "Template type",
		mod	=> "Module",
	});
	$cgi{dir} = "$cgi{mod}/$cgi{type}";
	selecttemplate();
}
elsif ($cgi{action} eq "othertemplates") {
	getcgi({
		type		=> "Template type",
	});
	if ($cgi{type} =~ /^search_(\w+)/) {
		$cgi{template} = $1;
		open (F, "< $cf{datapath}/templates/search/$cgi{template}")
			or err("Could not open $cf{datapath}/templates/search/$cgi{template}");
		$cf{text} = join("", <F>);
		$cf{dir} = "search";
		$cgi{mod} = "ANY";
		close F;
		prthtml("edittemplate/edit");
	}
	else { 
		($cgi{dir} = $cgi{type}) =~ s/_/\//;
		selecttemplate();
	}
}
elsif ($cgi{action} eq "edittemplate") {
	getcgi({
			dir		=> "Template directory",
			type		=> "Page type",
			mod		=> "Module",
		},
		"template",
	);
	if ($cgi{template} && open (F, "< $cf{datapath}/templates/$cgi{dir}/$cgi{template}")) { 
		$cf{text} = join("", <F>);
		close F;
	} else {
		$cf{template} = "";
		$cf{text} = "";
	}
	$cgi{mod} ||= "ANY";
	prthtml("edittemplate/edit");
}
elsif ($cgi{action} eq "deltemplate") {
	getcgi({
		dir		=> "Template directory",
		type		=> "Page type",
		mod		=> "Module",
		template	=> "Template name",
	});
	err("No such template: $cgi{template}")
		if !-e "$cf{datapath}/templates/$cgi{dir}/$cgi{template}";
	unlink "$cf{datapath}/templates/$cgi{dir}/$cgi{template}"
		or err("Could not remove template $cgi{template}, check permissions");
	$cf{done} = "Template " . uc($cgi{template}) . " deleted successfully";
	selecttemplate();
}
elsif ($cgi{action} eq "writetemplate") {
	getcgi({
		dir		=> "Template directory",
		type		=> "Template type",
		mod		=> "Module",
		template	=> "Template name",
		text		=> "HTML code",
		next		=> "Action",
	});
	$cgi{text} =~ tr/\r//d;
	err("Template name can only contain alphanumeric characters, full stop and underscore")
		if $cgi{template} =~ /[^\w.]/;
	$cgi{template} .= ".tmpl" if $cgi{template} !~ /\./;
	if ($cgi{next} =~ /preview/i) {

	} else {
		open (F, "> $cf{datapath}/templates/$cgi{dir}/$cgi{template}")
			or err("Could not write to template file, ensure permissions on templates/ are correct (run setperms.pl)");
		print F $cgi{text};
		close F;
		$cf{done} = "Template altered successfully";
		if ($cgi{dir} eq "search") {
			selecttemplatetype();
		} else {
			selecttemplate();
		} 
	}
}
elsif ($cgi{action} eq "edithtmlext") {
	my $ac = dosql(qq[select * from ap_htmlext]);
	while (my $row = $ac->fetchrow_arrayref) {
		$cf{htmlexts} .= "$$row[0]\n";
	}
	prthtml("edithtmlext");
}
elsif ($cgi{action} eq "writehtmlext") {
	getcgi({
		htmlexts	=> "HTML extensions",
	});
	err("No valid HTML extensions detected") if $cgi{htmlexts} !~ /\w/;
	my @exts = map { s/^\.//; $_ } split(/\s+/, $cgi{htmlexts});
	dosql("delete from ap_htmlext");
	dosql("insert into ap_htmlext values " .
		join(",", map { qq[("$_")] } @exts));
	$cf{done} = "Extensions updated";
	printindex();
}
elsif ($cgi{action} eq "imagetypes") {
	my $ac = dosql(qq[select name from ap_imagetypes]);
	$cf{typeselect} = qq[\t\t\t<option value="logo">logo\n].
			qq[\t\t\t<option value="content">content\n];
	while (my $type = ($ac->fetchrow_array)[0]) {
		$cf{imagetypes} .= "$type\n";
		$cf{typeselect} .= qq[\t\t\t<option value="$type">$type\n];
	}
	$cf{catselect} = catselect();
	prthtml("imagetypes/imagetypes");
}
elsif ($cgi{action} eq "writeimagetypes") {
	getcgi({
		imagetypes	=> "Image types",
	});
	my @types = split(/[\n\r]+/, $cgi{imagetypes});
	foreach my $type (@types) {
		err("Type $type too long, must be 10 letters or less")
			if length($type) > 10;
		err("Type $type contains invalid characters")
			if $type =~ /[^\w-]/;
		err("Illegal type: $_") if $_ eq "sets";
		foreach (@cats) {
			mkdir_r ("$cf{datapath}/images/$_/$type");
		}
	}
	dosql(qq[delete from ap_imagetypes]);
	dosql(qq[insert into ap_imagetypes values ] .
		join(", ", map { qq[("$_")] } @types));
	$cf{done} = "Image types saved successfully";
	printindex();	
}
elsif ($cgi{action} eq "imguploadloc") {
	getcgi({
		type	=> "Image type",
		cat	=> "Niche",
	});
	$cf{path} = "$cf{imagepath}/$cgi{cat}/$cgi{type}";
	prthtml("imagetypes/uploadloc");
}
elsif ($cgi{action} eq "editcats") {
	my $ac = dosql(qq[select * from ap_cats]);
	while (my $row = $ac->fetchrow_arrayref) {
		$cf{cats} .= "$$row[0]\n";
	}
	prthtml("editcats");
}
elsif ($cgi{action} eq "writecats") {
	getcgi({
		cats		=> "Categories",
	});
	err("No categories detected") if $cgi{cats} !~ /\w/;
	my @ccats = grep { /\w/ } split(/\s+/, $cgi{cats});
	my $ac = dosql(qq[select name from ap_imagetypes]);
	my @imagetypes;
	push (@imagetypes, $_) while $_ = ($ac->fetchrow_array)[0];
	foreach my $cat (@ccats) {
		err("Category <b>$cat</b> too long, names must be 10 characters or less") if length($cat) > 10;
		mkdir_r ("$cf{imagepath}/$cat");
		foreach (@imagetypes, "content", "sets") {
			mkdir_r ("$cf{imagepath}/$cat/$_");
		}
	}
	dosql("delete from ap_cats");
	dosql("insert into ap_cats values ".
		join(",", map { qq[("$_")] } @ccats));
	$cf{done} = "Category list updated";
	printindex();
}
elsif ($cgi{action} eq "editnames") {
	prthtml("editnames/head");
	foreach my $cat ("", @cats) {
		$cf{cat} = $cat;
		$cf{names} = "";
		my $ac = dosql(qq[select name from ap_sitenames where cat = "$cf{cat}"]);
		while (my $name = ($ac->fetchrow_array)[0]) {
			$cf{names} .= "$name\n";
		}
		$cf{cat} = "ANY" if $cf{cat} eq "";
		prthtml("editnames/item");
	}
	prthtml("editnames/foot");
}
elsif ($cgi{action} eq "writenames") {
	foreach my $cat ("ANY", @cats) {
		getcgi({
			"names_$cat"	=> "Names for category: $cat",
		});
		my @names = grep { /\w/ } split(/[\n\r]+/, $cgi{"names_$cat"}) or next;
		foreach (@names) {
			err(qq[Name <b>"$_"</b> too long, must be 30 letters or less]) 
				if length($_ > 30);
		}
		my $catname = $cat eq "ANY" ? "" : $cat;
		dosql(qq[delete from ap_sitenames where cat = "$catname"]);
		dosql("insert into ap_sitenames values " .
			join(",", map { qq[("$_", "$catname")] } @names));
	}
	$cf{done} = "Site names updated successfully";
	printindex();
}
elsif ($cgi{action} eq "editheaders") {
	prthtml("editheaders/head");
	foreach my $cat ("", @cats) {
		$cf{cat} = $cat;
		$cf{headers} = "";
		my $ac = dosql(qq[select text from ap_headers where cat = "$cf{cat}"]);
		while (my $header = ($ac->fetchrow_array)[0]) {
			$cf{headers} .= "$header\n";
		}
		$cf{cat} = "ANY" if $cf{cat} eq "";
		prthtml("editheaders/item");
	}
	prthtml("editheaders/foot");
}
elsif ($cgi{action} eq "writeheaders") {
	foreach my $cat ("ANY", @cats) {
		getcgi({
			"headers_$cat"	=> "Headers for category: $cat",
		});
		my @headers = grep { /\w/ } split(/[\n\r]+/, $cgi{"headers_$cat"})
			or next;
		foreach (@headers) {
			err(qq[Header "$_" too long, must be 60 letters or less])
				if length($_) > 60;
		}
		my $catname = $cat eq "ANY" ? "" : $cat;
		dosql(qq[delete from ap_headers where cat = "$catname"]);
		dosql("insert into ap_headers values " .
			join(",", map { qq[("$_", "$catname")] } @headers));
	}
	$cf{done} = "Headers updated successfully";
	printindex();
}

elsif ($cgi{action} eq "editdescr") {
	prthtml("editdescr/head");
	my $ac = dosql(qq[select * from ap_descr]);
	$cf{num} = 0;
	while (my $row = $ac->fetchrow_hashref) {
		$cf{num}++;
		$cf{text} = $$row{text};
		my @ccats = split(/ /, $$row{cats});
		foreach (1..4) {
			$cf{"catselect_$_"} = catselect(shift @ccats);
		}
		prthtml("editdescr/item");
	}
	$cf{text} = "";
	$cf{catselect} = catselect();
	foreach (1..4) {
		$cf{num}++;
		prthtml("editdescr/blank");
	}
	prthtml("editdescr/foot");
}
elsif ($cgi{action} eq "writedescrs") {
	getcgi({
		numdescs	=> "Number of descriptions",
		next		=> "Action to perform upon writing",
	});
	dosql(qq[delete from ap_descr]);
	foreach my $n (1..$cgi{numdescs}) {
		getcgi(
			"descr_$n",
			"cat_${n}_1",
			"cat_${n}_2",
			"cat_${n}_3",
			"cat_${n}_4",
			"cat_${n}_5",			
		);
		my $text = $cgi{"descr_$n"} || next;
		my $cats = join(" ", map { $cgi{"cat_${n}_$_"} } 1..4);
		$cats =~ s/\s+/ /g;
		$cats =~ s/^\s+//;
		$cats =~ s/\s+$//;
		dosql(qq[insert into ap_descr values("$text", "$cats")]);
	}
	$cf{done} = "Updated descriptions successfully";
	if ($cgi{next} =~ /^add/i) {
		redir("editdescr");
	} else {
		printindex();
	}
}
elsif ($cgi{action} eq "editparagraphs") {
	prthtml("editparagraphs/head");
	my $ac = dosql(qq[select * from ap_paragraphs]);
	$cf{num} = 0;
	while (my $row = $ac->fetchrow_hashref) {
		$cf{num}++;
		$cf{text} = $$row{text};
		my @ccats = split(/ /, $$row{cats});
		foreach (1..4) {
			$cf{"catselect_$_"} = catselect(shift @ccats);
		}
		prthtml("editparagraphs/item");
	}
	$cf{text} = "";
	$cf{catselect} = catselect();
	foreach (1..4) {
		$cf{num}++;
		prthtml("editparagraphs/blank");
	}
	prthtml("editparagraphs/foot");	
}
elsif ($cgi{action} eq "writeparagraphs") {
	getcgi({
		numparas	=> "Number of paragraphs",
		next		=> "Action to perform upon writing",
	});
	dosql(qq[delete from ap_paragraphs]);
	foreach my $n (1..$cgi{numparas}) {
		getcgi(
			"para_$n",
			"cat_${n}_1",
			"cat_${n}_2",
			"cat_${n}_3",
			"cat_${n}_4",
			"cat_${n}_5",
		);
		(my $text = $cgi{"para_$n"}) =~ s/\s*$//;
		next if !$text;
		my $cats = join(" ", map { $cgi{"cat_${n}_$_"} } 1..4);
		$cats =~ s/\s+/ /g;
		$cats =~ s/^\s+//;
		$cats =~ s/\s+$//;
		dosql(qq[insert into ap_paragraphs values("$text", "$cats")]);
	}
	$cf{done} = "Updated paragraphs successfully";
	if ($cgi{next} =~ /^add/i) {
		redir("editparagraphs");
	} else {
		printindex();
	}
}
elsif ($cgi{action} eq "editkeywords") {
	prthtml("editkeywords/head");
	$cf{keywords} = "";
	$cf{cat} = "ANY";
	my $ac = dosql(qq[select word from ap_keywords where cats = ""]);
	while (my $word = ($ac->fetchrow_array)[0]) {
		$cf{keywords} .= "$word ";
	}
	chomp $cf{keywords};
	prthtml("editkeywords/item");
	
	foreach my $cat (@cats) {
		$cf{cat} = $cat;
		$cf{keywords} = "";
		my $ac = dosql(qq[select word from ap_keywords where cats regexp "$cf{cat}"]);
		while (my $word = ($ac->fetchrow_array)[0]) {
			$cf{keywords} .= "$word ";
		}
		chomp $cf{keywords};
		prthtml("editkeywords/item");
	}
	prthtml("editkeywords/foot");
}
elsif ($cgi{action} eq "writekeywords") {
	my %words;
	foreach my $cat ("ANY", @cats) {
		getcgi({
			"keywords_$cat"  => "Keywords for category: $cat",
		});
		my @words = grep { /\w/ }  split(/[,\s]/, $cgi{"keywords_$cat"});
		foreach (@words) {
			err(qq[Keyword <b>"$_"</b> too long, must be 20 letters or less"])
				if length($_) > 20;
			$words{$_} .= ($cat eq "ANY"? "" : "$cat ");
		}
	}
	dosql(qq[delete from ap_keywords]);
	foreach my $word (keys %words) {
		chomp $words{$word};
		dosql(qq[insert into ap_keywords values("$word", "$words{$word}")]);
	}
	$cf{done} = "Keywords updated successfully";
	printindex();
}
elsif ($cgi{action} eq "editdomainlist") {
	prthtml("editdomainlist/head");
	my $ac = dosql(qq[select * from ap_domains]);
	$cf{num} = 0;
	while (my $row = $ac->fetchrow_hashref) {
		$cf{num}++;
		@cf{"domain","dir"} = @$row{"domain","dir"};
		my @ccats = split(/ /, $$row{cats});
		foreach (1..4) {
			$cf{"catselect_$_"} = catselect(shift @ccats);
		}
		prthtml("editdomainlist/item");
	}
	$cf{text} = "";
	$cf{catselect} = catselect();
	foreach (1..4) {
		$cf{num}++;
		prthtml("editdomainlist/blank");
	}
	prthtml("editdomainlist/foot");
}
elsif ($cgi{action} eq "writedomainlist") {
	getcgi({
		numdomains	=> "Number of domains",
		next		=> "Action to perform upon writing",
	});
	dosql(qq[delete from ap_domains]);
	foreach my $n (1..$cgi{numdomains}) {
		getcgi(
			"domain_$n",
			"dir_$n",
			"cat_${n}_1",
			"cat_${n}_2",
			"cat_${n}_3",
			"cat_${n}_4",
			"cat_${n}_5",
		);
		my $domain = $cgi{"domain_$n"} || next;
		$domain =~ s/\/+$//;
		err("Invalid domain: $domain")
			if ($domain !~ /^[\w.\/~-]+$/);
		my $dir = $cgi{"dir_$n"} || err("No path specified for domain: $domain");
		$dir =~ s/\/+$//;
		my $cats = join(" ", map { $cgi{"cat_${n}_$_"} } 1..4);
		$cats =~ s/\s+/ /g;
		$cats =~ s/^\s+//;
		$cats =~ s/\s+$//;
		dosql(qq[insert into ap_domains values("$domain", "$cats", "$dir")]);
	}
	$cf{done} = "Updated domain list successfully";
	if ($cgi{next} =~ /^add/i) { 
		redir("editdomainlist");
	} else {
		printindex();
	}
}
elsif ($cgi{action} eq "editdirlist") {
	prthtml("editdirlist/head");
	my $ac = dosql(qq[select * from ap_dirs]);
	$cf{num} = 0;
	while (my $row = $ac->fetchrow_hashref) {
		$cf{num}++;
		$cf{dir} = $$row{dir};
		my @ccats = split(/ /, $$row{cats});
		foreach (1..4) {
			$cf{"catselect_$_"} = catselect(shift @ccats);
		}
		prthtml("editdirlist/item");
	}
	$cf{text} = "";
	$cf{catselect} = catselect();
	foreach (1..4) {
		$cf{num}++;
		prthtml("editdirlist/blank");
	}
	@cf{"direxts","memareas"} = ("", "");
	$ac = dosql(qq[select * from ap_direxts]);
	$cf{direxts} .= "$_\n" while $_ = ($ac->fetchrow_array)[0];	 
	$ac = dosql(qq[select * from ap_memarea]);
	$cf{memareas} .= "$_\n" while $_ = ($ac->fetchrow_array)[0];

	prthtml("editdirlist/foot");
}
elsif ($cgi{action} eq "writedirlist") {
	getcgi({
		numdirs		=> "Number of directories",
		next		=> "Action to perform upon writing",
	});
	dosql(qq[delete from ap_dirs]);
	foreach my $n (1..$cgi{numdirs}) {
		getcgi(
			"dir_$n",
			"cat_${n}_1",
			"cat_${n}_2",
			"cat_${n}_3",
			"cat_${n}_4",
			"cat_${n}_5",
		);
		my $dir = $cgi{"dir_$n"} || next;
		err("Directory names must be 20 letters or less")
			if length($dir) > 20;
		$dir =~ s/[^\w.-]//g;
		my $cats = join(" ", map { $cgi{"cat_${n}_$_"} } 1..4);
		$cats =~ s/\s+/ /g;
		$cats =~ s/^\s+//;
		$cats =~ s/\s+$//;
		dosql(qq[insert into ap_dirs values("$dir", "$cats")]);
	}
	$cf{done} = "Updated directories successfully";
	if ($cgi{next} =~ /^add/i) {
		redir("editdirlist");
	} else {
		printindex();
	}
}
elsif ($cgi{action} eq "writedirexts") {
	getcgi({
		exts	=> "Directory extensions",
	});
	err("No valid extensions") if $cgi{exts} !~ /\w/;
	my @exts = grep { /\w/ } split(/\s+/, $cgi{exts});
	foreach (@exts) {
		err("Directory names must be 12 characters or less")
			if length($_) > 12;
		s/[^\w.\/-]//g;
		s/\/$//;
	}
	dosql("delete from ap_direxts");
	dosql("insert into ap_direxts values " .
		join(",", map { qq[("$_")] } @exts));
	$cf{done} = "Directory extensions updated";
	printindex();
}
elsif ($cgi{action} eq "writememareas") {
	getcgi({
		dirs	=> "Directories",
        });
	err("No valid directories") if $cgi{dirs} !~ /\w/;
	my @dirs = grep { /\w/ } split(/\s+/, $cgi{dirs});
	foreach (@dirs) {
		err("Directory names must be 40 characters or less")
			if length($_) > 40;
		s/[^\w.\/-]//g;
		s/\/$//;
	}
	dosql("delete from ap_memarea");
	dosql("insert into ap_memarea values " .
		join(",", map { qq[("$_")] } @dirs));
	$cf{done} = "Content area directories updated";
	printindex();
}
elsif ($cgi{action} eq "editavsdirs") {
	prthtml("editavsdirs/head");
	my $ac = dosql(qq[select id, name, dir from ap_avs]);
	while (@cf{"id", "name", "dir"} = $ac->fetchrow_array) {
		prthtml("editavsdirs/item");
	}
	prthtml("editavsdirs/foot");
}
elsif ($cgi{action} eq "writeavsdirs") {
	my $ac = dosql(qq[select id, name from ap_avs]);
	my %avs;
	$avs{$$_{id}} = $$_{name} while $_ = $ac->fetchrow_hashref;
	getcgi(keys %avs);
	foreach my $avs (keys %avs) {
		err("Directory for AVS $avs{$avs} not specified")
			if !$cgi{$avs};
		err("Directory names must be 12 or less alphanumeric characters")
			if length($cgi{$avs}) > 12 or $cgi{$avs} =~ /[^\w-]/;
		dosql(qq[update ap_avs set dir="$cgi{$avs}" where id="$avs"]);
	}
	$cf{done} = "AVS directories successfully updated";
	printindex();
}
elsif ($cgi{action} eq "edithtaccess") {
	$cf{htaccess} = readfile("$cf{datapath}/data/htaccess");
	prthtml("edithtaccess");
}
elsif ($cgi{action} eq "writehtaccess") {
	getcgi({
		htaccess	=> "htaccess content",
	});
	open (F, "> $cf{datapath}/data/htaccess")
		or err("Could not write to htaccess file, check permissions or run setperms.pl");
	print F $cgi{htaccess};
	close F;
	$cf{done} = "Updated htaccess file successfully";
	printindex();
}
elsif ($cgi{action} eq "quicksponsors") {
	$cf{catselect} = catselect();
	$cf{sponselect} = "";
	my $ac = dosql(qq[select id,name from ap_sponsors]);
	$cf{sponselect} .= qq[\t\t<option value=$$_[0]>$$_[1]\n]
		while $_ = $ac->fetchrow_arrayref;
	prthtml("editsponsors/select");
}
elsif ($cgi{action} eq "editsponsors") {
	prthtml("editsponsors/head");
	getcgi("cat");
	$cgi{cat} ||= "";
	my $ac = dosql(qq[select * from ap_sponsors] .
		($cgi{cat} ? qq[ where cats regexp "$cgi{cat}"]: ""));
	$cf{num} = 0;
	while (my $row = $ac->fetchrow_hashref) {
		$cf{num}++;
		@cf{"id", "name", "linkcode"} = @$row{"id", "name", "linkcode"};
		my @ccats = split(/ /, $$row{cats});
		foreach (1..4) {
			$cf{"catselect_$_"} = catselect(shift @ccats);
		}
		prthtml("editsponsors/item");
	}
	$cf{text} = "";
	$cf{catselect} = catselect();
	foreach (1..4) {
		$cf{num}++;
		prthtml("editsponsors/blank");
	}
	prthtml("editsponsors/foot");
}
elsif ($cgi{action} eq "addsponsors") {
	foreach my $n (1..2) {
		getcgi(
			"id_$n",
			"name_$n",
			"banner_$n",
			"linkcode_$n",
			"cat_${n}_1",
			"cat_${n}_2",
			"cat_${n}_3",
			"cat_${n}_4",
			"cat_${n}_5",
		);
		my $id = $cgi{"id_$n"} or next;
		err("Sponsor IDs must be 12 or less alphanumeric characters")
			if (length($id) > 12 || $id =~ /\W/);
		my $name = $cgi{"name_$n"} or next;
		err("Sponsor name must be 30 letters or less")
			if length($name) > 30;
		my $linkcode = $cgi{"linkcode_$n"} or next;
		err("Linkcode must be 120 characters or less")
			if length($linkcode) > 120;
		my $cats = join(" ", map { $cgi{"cat_${n}_$_"} } 1..4);
		$cats =~ s/\s+/ /g; $cats =~ s/^\s+//; $cats =~ s/\s+$//;
		if ($cgi{"banner_$n"}) {
			my $filepath = $cgi{"banner_$n"}->{name};
			(my $fname = $filepath)
				=~ s/^.*[\\\/:]([^\\\/:]+)$/$1/;
			my $content = $cgi{"banner_$n"}->{content}
				or err("No data read?");
			mkdir_r("$cf{imagepath}/banners/$id");
			open (F, "> $cf{imagepath}/banners/$id/$fname")
				or err("Could not write to $cf{imagepath}/banners/$id/$fname");
			print F $content;
			close F;
		}
		dosql(qq[insert into ap_sponsors values("$id", "$name", "$cats", "$linkcode")]);
	}
	$cf{done} = "Updated sponsors successfully";
	printindex();
}
elsif ($cgi{action} eq "delsponsor") {
	getcgi({
		sponsor		=> "Sponsor to delete",
	});
	if (dosql(qq[delete from ap_sponsors where id="$cgi{sponsor}"])->rows) {
		$cf{catselect} = catselect();
		$cf{sponselect} = "";
		my $ac = dosql(qq[select id,name from ap_sponsors]);
		$cf{sponselect} .= qq[\t\t<option value=$$_[0]>$$_[1]\n]
			while $_ = $ac->fetchrow_arrayref;
		$cf{done} = "Sponsor deleted successfully";
		prthtml("editsponsors/select");                                                        
	} else {
		err("No such sponsor id: $cgi{sponsor}");
	}
}
elsif ($cgi{action} eq "writesponsors") {
	getcgi(	{
			numsponsors	=> "Number of sponsors",
			next		=> "Action to perform upon writing",
        	},
        	"cat"
        );
	dosql(qq[delete from ap_sponsors]);
	foreach my $n (1..$cgi{numsponsors}) {
		getcgi(
			"id_$n",
			"name_$n",
			"banner_$n",
			"linkcode_$n",
			"cat_${n}_1",
			"cat_${n}_2",
			"cat_${n}_3",
			"cat_${n}_4",
			"cat_${n}_5",
		);
		my $id = $cgi{"id_$n"} or next;
		err("Sponsor IDs must be 12 or less alphanumeric characters")
			if (length($id) > 12 || $id =~ /\W/);
		my $name = $cgi{"name_$n"} or next;
		err("Sponsor name must be 30 letters or less")
			if length($name) > 30;
		my $linkcode = $cgi{"linkcode_$n"} or next;
		err("Linkcode must be 120 characters or less")
			if length($linkcode) > 120;
		my $cats = join(" ", map { $cgi{"cat_${n}_$_"} } 1..4);
		$cats =~ s/\s+/ /g; $cats =~ s/^\s+//; $cats =~ s/\s+$//;
		if ($cgi{"banner_$n"}) {
			my $filepath = $cgi{"banner_$n"}->{name};
			(my $fname = $filepath) =~ s/^.*[\\\/:]([^\\\/:]+)$/$1/;
			my $content = $cgi{"banner_$n"}->{content}
				or err("No data read?");			                                
			mkdir_r("$cf{imagepath}/banners/$id");
			open (F, "> $cf{imagepath}/banners/$id/$fname")
				or err("Could not write to $cf{imagepath}/banners/$id/$fname");
			print F $content;
			close F;
		}
		dosql(qq[insert into ap_sponsors values("$id", "$name", "$cats", "$linkcode")]);
	}
	$cf{done} = "Updated sponsors successfully";
	if ($cgi{next} =~ /^add/i) {
		redir("editsponsors?cat=$cgi{cat}");
	} else {
		printindex();
	}
}
elsif ($cgi{action} eq "edittextlinks") {
	edittextlinks();
}
elsif ($cgi{action} eq "editcattextlinks") {
	getcgi("cat");
	my $ac = dosql(qq[select text from ap_textlinks where cat="$cgi{cat}" and sponsor=""]);
	$cf{textlinks} = "";
	$cf{textlinks} .= qq[$_\n] while $_ = ($ac->fetchrow_array)[0];
	$cf{type} = "cat";
	$cf{set} = $cgi{cat};
	prthtml("edittextlinks/edit");
}
elsif ($cgi{action} eq "editspontextlinks") {
	getcgi({ sponsor => "Sponsor" });
	my $ac = dosql(qq[select text from ap_textlinks where sponsor="$cgi{sponsor}"]);
	$cf{textlinks} = "";
	$cf{textlinks} .= qq[$_\n] while $_ = ($ac->fetchrow_array)[0];
	$cf{type} = "sponsor";
	$cf{set} = $cgi{sponsor};
	prthtml("edittextlinks/edit");
}
elsif ($cgi{action} eq "writetextlinks") {
	getcgi(	{
			type		=> "Textlink type",
			textlinks	=> "Text links",
		},
		"set",
	);
	my @textlinks;
	foreach (grep { /\w/ } split(/[\n\r]+/, $cgi{textlinks})) {
		err(qq[Textlink "$_" too long, must be 240 characters or less])
			if length($_) > 240;
		push(@textlinks, $_);
	}
	if ($cgi{type} eq "cat") {
		dosql(qq[delete from ap_textlinks where cat="$cgi{set}" and sponsor=""]);
		dosql(qq[insert into ap_textlinks values ].
			join(", ", map { qq[("$_", "", "$cgi{set}")] } @textlinks));
	} else {
		dosql(qq[delete from ap_textlinks where sponsor="$cgi{set}"]);
		dosql(qq[insert into ap_textlinks values ].
			join(", ", map { qq[("$_", "$cgi{set}", "")] } @textlinks));
	}
	$cf{done} = "Text links saved successfully";
	edittextlinks();
}
elsif ($cgi{action} eq "editsubs") {
	my $ac = dosql(qq[select id, name, enabled from ap_avs]);
	$cf{avslist} = "";
	while (my ($id, $name, $enabled) = $ac->fetchrow_array) {
		$enabled = ($enabled ? "checked" : "");
		$cf{avslist} .= qq[\t<input type=checkbox name=$id $enabled> $name<br>\n];
	}
	$ac = dosql(qq[select id, name, enabled from ap_se]);
	$cf{selist} = "";
	while (my ($id, $name, $enabled) = $ac->fetchrow_array) {
		$enabled = ($enabled ? "checked" : "");
		$cf{selist} .= qq[\t<input type=checkbox name=$id $enabled> $name<br>\n];
	}
	prthtml("editsubs");
}
elsif ($cgi{action} eq "writesubs") {
	my (@avs, @se);
	my $ac = dosql(qq[select id from ap_avs]);
	push (@avs, $_) while ($_ = ($ac->fetchrow_array)[0]);
	$ac = dosql(qq[select id from ap_se]);
	push (@se, $_) while ($_ = ($ac->fetchrow_array)[0]);
	getcgi(@avs, @se);
	foreach (@avs) {
		my $enabled = ($cgi{$_} ? 1 : 0);
		err("Too many AVSs enabled, can only submit to 8 at one time")
			if ($enabled && (dosql(qq[select count(*) from ap_avs where enabled=1 and id != "$_"])->fetchrow_array)[0] == 8);
		dosql(qq[update ap_avs set enabled = $enabled where id = "$_"]);
	}
	foreach (@se) {
		my $enabled = ($cgi{$_} ? 1 : 0);
		dosql(qq[update ap_se set enabled = $enabled where id = "$_"]);
	}
	$cf{done} = "Active AVS/SE lists altered successfully";
	printindex();
}
elsif ($cgi{action} eq "editaccounts") {
	prthtml("editaccounts/head");
	$cf{num} = 0;
	my %avs;
	my $ac = dosql(qq[select id, name from ap_avs]);
	while (my ($id, $name) = ($ac->fetchrow_array)) {
		$avs{$id} = $name;
	}
	$ac = dosql(qq[select id, avs, acct, pass, enabled from ap_avs_accounts order by id]);
	while (my $row = $ac->fetchrow_hashref) {
		@cf{"id", "acct", "pass"} = @$row{"id", "acct", "pass"};
		$cf{enabled} = ($$row{enabled} ? "checked" : "");
		$cf{avsselect} = "";
		foreach (keys %avs) {
			my $selected = ($$row{avs} eq $_ ? "selected" : "");
			$cf{avsselect} .= qq[\t<option value=$_ $selected>$avs{$_}\n];
		}
		prthtml("editaccounts/item");
	}
	$cf{avsselect} = "";
	foreach (keys %avs) {
		$cf{avsselect} .= qq[\t<option value=$_>$avs{$_}\n];
	}
	foreach (1..4) {
		$cf{id}++;
		prthtml("editaccounts/blank");
	}
	prthtml("editaccounts/foot");	
}
elsif ($cgi{action} eq "writeaccounts") {
	getcgi({
		lastid		=> "Number of AVS accounts",
		next		=> "Action to perform upon writing",
	});
	foreach my $n (1..$cgi{lastid}) {
		getcgi(
			"avs_$n",
			"acct_$n",
			"pass_$n",
			"enabled_$n",
		);
		my ($acct, $pass, $avs) = @cgi{"acct_$n", "pass_$n", "avs_$n"};
		if (!$acct && !$pass) {
			dosql(qq[delete from ap_avs_accounts where id=$n]);
			next;
		}
		my $enabled = ($cgi{"enabled_$n"} ? 1 : 0);
		dosql(qq[replace into ap_avs_accounts set id=$n, avs="$avs", acct="$acct", pass="$pass", enabled=$enabled]);
	}
	$cf{done} = "Updated AVS accounts successfully";
	if ($cgi{next} =~ /^add/i) {
		redir("editaccounts");
	} else {
		printindex();
	}
}
elsif ($cgi{action} eq "assigncatselect") {
	$cf{avsselect} = avsselect();
	prthtml("assigncats/select");
}
elsif ($cgi{action} eq "assigncats") {
	getcgi({
		avs => "AVS ID",
	});
	my (@avscats, %cur);
	my $ac = dosql(qq[select catspersub from ap_avs where id="$cgi{avs}"]);
	$cf{num} = ($ac->fetchrow_array)[0]
		or err("No such AVS: $cgi{avs}");
	$ac = dosql(qq[select code, fvalue, name from ap_avs_cats where avs="$cgi{avs}"]);
	while (my $row = $ac->fetchrow_hashref) {
		push(@avscats, $row);
	}
	$ac = dosql(qq[select * from ap_avs_catmap where avs="$cgi{avs}"]);
	while (my $row = $ac->fetchrow_hashref) {
		my $cat = delete $$row{cat};
		delete $$row{avs};
		$cur{$cat} = $row;
	}
	
	prthtml("assigncats/head");
	foreach (@cats) {
		$cf{cat} = $_;
		foreach my $n (1..3) {
			if ($n > $cf{num}) {
				$cf{"catselect_$n"} = "";
			} else {
				my $href = $cur{$cf{cat}};
				$cf{"catselect_$n"} = qq[\t<select name="$cf{cat}_$n">\n] .
					codeselect($$href{"code_$n"}, $$href{"value_$n"}) .
					qq[\t</select>\n];
			}
		}
		prthtml("assigncats/item");
	}
	prthtml("assigncats/foot");

	sub	codeselect {
		my $out = qq[\t<option value="">-\n];
		my $selected = join(",", @_[0,1]);
		foreach my $cat (@avscats) {
#			err("selected $selected, codestuff $$cat{code},$$cat{fvalue}");
			$out .= qq[\t<option value="$$cat{code},$$cat{fvalue}" ].
				("$$cat{code},$$cat{fvalue}" eq $selected ? "selected" : "").
				qq[>$$cat{name}\n];
		}
		return $out;
	}
}
elsif ($cgi{action} eq "writecatassigns") {
	getcgi({
		avs => "AVS ID",
	});
	my $ac = dosql(qq[select catspersub from ap_avs where id="$cgi{avs}"]);
	my $num = ($ac->fetchrow_array)[0]
		or err("No such AVS: $cgi{avs}");

	my @toget;
	foreach my $cat (@cats) {
		foreach (1..$num) {
			push(@toget, "${cat}_$_");
		}
	}
	getcgi(@toget);
	dosql(qq[delete from ap_avs_catmap where avs="$cgi{avs}"]);
	foreach my $cat (@cats) {
		my @codes = grep(/\w/, @cgi{"${cat}_1", "${cat}_2", "${cat}_3"});
		next if $#codes < 0;
		my $codes = join(",",  map { "\"". (split(/,/))[0] . "\", \"" . (split(/,/))[1] . "\"" } @codes[0..2]);
		dosql(qq[insert into ap_avs_catmap values("$cgi{avs}", "$cat", $codes)]);
	}

	$cf{avsselect} = avsselect();
	$cf{done} = "Niche assignments updated successfully";
	prthtml("assigncats/select");
}
elsif ($cgi{action} eq "editfreehosts") {
	prthtml("editfreehosts/head");
	$cf{num} = 0;
	$ac = dosql(qq[select * from ap_freehosts]);
	while (my $row = $ac->fetchrow_hashref) {
		foreach ("id", "name", "host", "port", "user", "pass", "rootdir", "rooturl") {
			$cf{$_} = $$row{$_};
		}
		$cf{enabled} = ($$row{enabled} ? "checked" : "");
		prthtml("editfreehosts/item");
	}
	foreach (1..4) {
		$cf{id}++;
		prthtml("editfreehosts/blank");
	}
	prthtml("editfreehosts/foot");
}
elsif ($cgi{action} eq "writefreehosts") {
	getcgi({
		lastid		=> "Last freehost ID #",
		next		=> "Action to perform upon writing",
	});
	foreach my $n (1..$cgi{lastid}) {
		getcgi(
			"name_$n",
			"host_$n",
			"port_$n",
			"user_$n",
			"pass_$n",
			"rootdir_$n",
			"rooturl_$n",
			"enabled_$n",
		);
		my ($name, $host, $user) = @cgi{"name_$n", "host_$n", "user_$n"};
		if (!$name || !$host || !$user) {
			dosql(qq[delete from ap_freehosts where id=$n]);
			next;
		}
		my $port = $cgi{"port_$n"} || 21;
		my ($pass, $rootdir, $rooturl) = @cgi{"pass_$n", "rootdir_$n", "rooturl_$n"};
		my $enabled = ($cgi{"enabled_$n"} ? 1 : 0);
		dosql(qq[replace into ap_freehosts values("$n", "$name", "$host", "$port", "$user", "$pass", "$rootdir", "$rooturl", $enabled)]);
	}
	$cf{done} = "Updated freehost accounts successfully";
	if ($cgi{next} =~ /^add/i) {
		redir("editfreehosts");
	} else {
		printindex();
	}
}
elsif ($cgi{action} eq "viewsites") {
	getcgi(
		"num",
		"cat",
		"avs",
		"domain",
	);
	viewsites();
}
elsif ($cgi{action} eq "siteinfo") {
	getcgi({
		id	=> "Site ID",
	});
	siteinfo();
}
elsif ($cgi{action} eq "editfile") {
	getcgi({
		id	=> "Site to edit file within",
		file	=> "Filename",
	});
	my $ac = dosql(qq[select sitename, domain from ap_sites where id="$cgi{id}"]);
	err("No such site ID: $cgi{id}") if !$ac->rows;
	@cgi{"sitename", "domain"} = $ac->fetchrow_array;
	my $dpath = (dosql(qq[select dir from ap_domains where domain="$cgi{domain}"])->fetchrow_array)[0];
	err("Invalid file...") if $cgi{file} =~ /\.\./ || $cgi{file} !~ /\E$dpath\Q/;

	$cgi{text} = readfile($cgi{file});
	prthtml("editfile");
}
elsif ($cgi{action} eq "savefile") {
	getcgi({
		id	=> "Site to edit file within",
		file	=> "Filename",
		text	=> "File contents",
	});
	my $ac = dosql(qq[select sitename, domain from ap_sites where id="$cgi{id}"]);
	err("No such site ID: $cgi{id}") if !$ac->rows;
	@cgi{"sitename", "domain"} = $ac->fetchrow_array;
	my $dpath = (dosql(qq[select dir from ap_domains where domain="$cgi{domain}"])->fetchrow_array)[0];
	err("Invalid file...") if $cgi{file} =~ /\.\./ || $cgi{file} !~ /\E$dpath\Q/;
	open (F, "> $cgi{file}")
		or err("Could not write to file $cgi{file}");
	print F $cgi{text};
	close F;
	$cf{done} = "File saved successfully";
	siteinfo();
}
elsif ($cgi{action} eq "editusers") {
	my $ac = dosql(qq[select uid,username from ap_users where uid > 1]);
	while (my ($uid, $username) = $ac->fetchrow_array) {
		$cf{userselect} .= qq[\t\t<option value=$uid>$username\n];
	}
	prthtml("editusers");
}
elsif ($cgi{action} eq "deluser") {
	getcgi({ uid	=> "User ID" });
	err("Cannot delete admin user") if $cgi{uid} == 1;
	err("Cannot delete yourself!") if $cgi{uid} eq $cf{uid};
	dosql(qq[delete from ap_users where uid = "$cgi{uid}"]);
	$cf{done} = "User deleted successfully";
	prthtml("editusers");
}
elsif ($cgi{action} eq "adduser") {
	getcgi({
		username	=> "Username",
		password	=> "Password",
		confirm		=> "Confirm password",
	});
	err("Invalid username") if $cgi{username} =~ /[^\w-]/;
	err("Passwords do not match") if $cgi{password} ne $cgi{confirm};
	err("Password too short, please ensure it is at least 6 characters")
		if length($cgi{password}) < 6;
	my $ac = dosql(qq[select uid from ap_users where username="$cgi{username}"]);
	err("Username already exists!") if $ac->rows;
	my $hash = hash($cgi{password});
	dosql(qq[insert into ap_users values("", "$cgi{username}", "$hash", "", "")]);
	$cf{done} = "User ".uc($cgi{username})." added successfully";
	prthtml("editusers");
}
elsif ($cgi{action} eq "editperms") {
	my $ac = dosql(qq[select * from ap_actions]);
	while (my ($action, $level) = $ac->fetchrow_array) {
		$cf{$action} = ($level < 2 ? "checked" : "");
	}
	prthtml("editperms");
}
elsif ($cgi{action} eq "writeperms") {
	getcgi(@corefuncs);
	foreach my $action (@corefuncs) {
		my $level = ($cgi{$action} ? 1 : 2);
		dosql(qq[update ap_actions set permlevel = $level where action = "$action"]);
	}
	$cf{done} = "Permissions successfully altered";
	printindex();
}
elsif ($cgi{action} eq "gensetup") {
	my %data = %{dosql(qq[select * from ap_data])->fetchrow_hashref};
	# opt types -
	#  0 - binary
	#  1 - string
	foreach (keys %opts) {
		if ($opts{$_} == 0) {
			$cf{$_} = ($data{$_} ? "checked" : "");
		} else {
			$cf{$_} = $data{$_};
		}
	}
	my ($wday, $hr) = $cf{lsgtime} =~ /^(\d)(\d{1,2})$/;
	my @wdays = qw(
		Sunday
		Monday
		Tuesday
		Wednesday
		Thursday
		Friday
		Saturday
	);
	foreach (0..6) {
		$cf{lsgwday} .= qq[\t\t\t<option value=$_].
			($wday eq $_ ? " selected" : "").
			qq[>$wdays[$_]\n];
	}
	foreach (0..23) {
		$cf{lsghour} .= qq[\t\t\t<option value=$_].
			($hr eq $_ ? " selected" : "").
			qq[>]. sprintf("%02d:00", $_). qq[\n];
	}
	my $ac = dosql(qq[select name from ap_schemes]);
	$cf{searchscheme} = qq[\t\t<option value="">Random\n];
	while (my $row = $ac->fetchrow_hashref) {
		$cf{searchscheme} .= qq[\t\t<option value="$$row{name}"].
			($cf{searchscheme} eq $$row{name} ? " selected" : "").
			qq[>$$row{name}\n];
	}
	prthtml("gensetup");
}
elsif ($cgi{action} eq "writegensetup") {
	getcgi(
		keys %opts,
		"lsgwday",
		"lsghour",
	);
	$cgi{lsgtime} = $cgi{lsgwday} . $cgi{lsghour};
	dosql(qq[update ap_data set ] .
		join(", ", map {
			qq[$_ = "] .
			($opts{$_} == 0 ? ($cgi{$_} ? 1 : 0) : $cgi{$_}) .
			qq["]
		} keys %opts) .
		($cgi{pcpass} ? qq[, pcpass="$cgi{pcpass}"] : "" )
	);
	$cf{done} = "Configuration saved";
	printindex();
}
elsif ($cgi{action} eq "deltestsites") {
	my $ac = dosql(qq[select * from ap_testsites]);
	err("No test sites to delete") if !$ac->rows;
	qx(rm -rf $_) while $_ = ($ac->fetchrow_array)[0];
	dosql(qq[delete from ap_testsites]);
	$cf{done} = "Test sites deleted";
	printindex();
}
elsif ($cgi{action} eq "edittimers") {
	prthtml("edittimers/head");
	my $avsselect = avsselect();
	foreach my $hr (0..23) {
		my $ac = dosql(qq[select * from ap_schedule where hr="$hr"]);
		if ($ac->rows) {
			my $row = $ac->fetchrow_hashref;
			$cf{runs} = runselect($$row{runs});
			$cf{cat} = catselect($$row{cat});
			foreach (1..5) {
				if ($$row{"mod_$_"}) {
					$cf{"mod_$_"} = avsselect($$row{"mod_$_"});
				} else {
					$cf{"mod_$_"} = $avsselect;
				}
			}
			$cf{gls} = ($$row{genlinksite} ? "checked" : "");
		} else {
			$cf{runs} = runselect();
			$cf{cat} = catselect();
			map { $cf{"mod_$_"} = $avsselect } 1..5;
			$cf{gls} = "";
		}
		$cf{hr} = $hr;
		$cf{fmthr} = sprintf("%02d:00", $hr);
		prthtml("edittimers/item");
	}
	prthtml("edittimers/foot");

	sub	runselect {
		my $selected = shift(@_);
		my $options;
		foreach (0..8) {
			$options .= qq[\t<option value=$_].
				($selected == $_ ? " selected" : "").
				qq[>$_\n];
		}
		return $options;
	}
}
elsif ($cgi{action} eq "savetimers") {
	getcgi(map { (	"runs_$_",
			"cat_$_",
			"mod_1_$_",
			"mod_2_$_",
			"mod_3_$_",
			"mod_4_$_",
			"mod_5_$_",
			"gls_$_" 	) } 0..23);
	dosql(qq[delete from ap_schedule]);
	foreach my $hr (0..23) {
		next if !$cgi{"runs_$hr"};
		dosql(qq[insert into ap_schedule values("$hr", "$cgi{"runs_$hr"}",].
			qq[ "$cgi{"cat_$hr"}", "$cgi{"mod_1_$hr"}", "$cgi{"mod_2_$hr"}",].
			qq["$cgi{"mod_3_$hr"}","$cgi{"mod_4_$hr"}","$cgi{"mod_5_$hr"}", ].
			($cgi{"gls_$hr"} ? 1 : 0) . qq[)]);
	}
	$cf{done} = "Schedule updated successfully";
	printindex();
}
elsif ($cgi{action} eq "listpacks") {
	opendir (D, "$cf{datapath}/data")
		or err("Could not open data directory for read!");
	$cf{dpselect} = qq[\t<select name="datapack">\n];
	foreach (readdir D) {
		/^(\w+)\.dat$/ or next;
		$cf{dpselect} .= qq[\t\t<option value="$1">$1\n];
	}
	closedir(D);
	$cf{dpselect} .= qq[\t</select>\n];
	prthtml("datapack");
}
elsif ($cgi{action} eq "addpack") {
	getcgi({
		datapack	=> "Datapack name",
	});
	err("Datapack does not exist: $cgi{datapack}")
		if !-e "$cf{datapath}/data/$cgi{datapack}.dat";
	open (F, "< $cf{datapath}/data/$cgi{datapack}.dat")
		or err("Could not read datapack file, please check permissions on data/$cgi{datapack}.dat");
	chomp(my $cat = <F>);
	$cf{dp_cat} = "<select name=cat>\n" .
		catselect($cat) .
		"<option value=ALL>ALL NICHES\n".
		"</select>\n";
	prthtml("addpack");
}
elsif ($cgi{action} eq "doaddpack") {
	# must cope with:
	# - ready-made HTML templates
	# - HTML schemes and site structures
	# - sample site names, headers, descriptions, keywords and paragraphs
	# - custom directory and content area directory names

	getcgi({
		datapack	=> "Datapack name",
		cat		=> "Datapack category",
	});
	err("Invalid category selected") if (!grep(/^$cgi{cat}$/, @cats) and $cgi{cat} ne "ALL");
	$cgi{cat} = "" if $cgi{cat} eq "ALL";

	err("Datapack does not exist: $cgi{datapack}")
		if !-e "$cf{datapath}/data/$cgi{datapack}.dat";
	open (F, "< $cf{datapath}/data/$cgi{datapack}.dat")
		or err("Could not read datapack file, please check permissions");
	<F>;
	my $type;
	my @types = qw(sitenames headers descr paragraphs keywords scheme pagetypes layout template dirs direxts memarea);
	# scheme layout

	my $actions = 0;
	while (my $line = <F>) {
		chomp $line;
		if ($line eq "") {
			$type = "";
			next;
		}
		elsif ($type eq "") {
			next if !grep(/^$line$/, @types);
			$type = $line;
			next;
		}
		elsif (grep(/^$type$/, ("sitenames", "headers", "descr", "paragraphs", "keywords", "dirs"))) {
			$line =~ s!\\!\\\\!g;
			$line =~ s/"/\\"/g;
			dosql(qq[insert into ap_$type values("$line", "$cgi{cat}")]);
		}
		elsif (grep(/^$type$/, ("pagetypes", "direxts", "memarea"))) {
			dosql(qq[insert into ap_$type values("$line")]);			
		}
		elsif ($type eq "template") {
			my ($filename, $pagetype) = split(/\0/, $line);
			my $tmpl;
			while (<F> && $_ ne "\n") {
				$tmpl .= $_;
			}
			open (D, "> $cf{datapath}/templates/default/$pagetype/$filename")
				or err("Could not write to template file: $cf{datapath}/templates/default/$pagetype/$filename");
			print D $tmpl; close D;
		}
		$actions++;
	}
	$cf{done} = "Datapack installed successfully, $actions actions performed";
	printindex();
}
elsif ($cgi{action} eq "updatescript") {
	$cf{done} = qx($cf{datapath}/avspro.pl -uv);
	$cf{lastupdateid} = (dosql(qq[select lastupdateid from ap_data])->fetchrow_array)[0];
	$cf{version} = sprintf("1.%03d", $cf{lastupdateid});
	printindex();
}
elsif ($cgi{action} eq "support") {
	getcgi("subject");
	$cgi{subject} ||= "Support request";
	prthtml("support");
}
elsif ($cgi{action} eq "sendmail") {
	getcgi({
		subject		=> "Subject",
		message		=> "Message content",
	});
	foreach (qw(/usr/sbin/sendmail /usr/bin/sendmail /usr/lib/sendmail /var/qmail/bin/sendmail)) {
		$cf{sendmail} = $_, last if ($cf{sendmail} || -x $_);
	}
	err(qq[Could not find sendmail, please contact us through <a href="mailto:support\@avsmakerpro.com">].
		qq[this link</a> and mention this additional problem])
		if !$cf{sendmail};
	open (F, "| $cf{sendmail} -t")
		or err(qq[Could not find sendmail, please contact us through <a href="mailto:support\@avsmakerpro.com">].
		qq[this link</a> and mention this additional problem]);
	my $time = localtime()."";
	my $sysinf = `uname -a` || $^O || "Unknown";
	my $username = ($cf{uid} ? (dosql(qq[select username from ap_users where uid=($cf{uid} + 1)])->fetchrow_array)[0] : "");
	print F <<EOF;
To: support\@avsmakerpro.com
From: $cf{email}
Subject: [avspro] $cgi{subject}

Problem report:
----------------------
$cgi{message}
----------------------

Server Information
Datapath - $cf{datapath}
CGI URL  - $cf{cgiurl}
Host     - $ENV{HTTP_HOST}, $ENV{SERVER_NAME} ($ENV{SERVER_ADDR})
System   - $sysinf
Perl     - $]
Server   - $ENV{SERVER_SOFTWARE}

Sent from IP address $ENV{REMOTE_ADDR},
AVSMaker Pro username $username (uid $cf{uid}), at
$time.

EOF
	close F;
	$cf{done} = "Support request sent successfully";
	printindex();
}
elsif ($cgi{action} eq "doc") {
	my $ac = dosql(qq[select * from ap_actions]);
	while (my ($action, $perm) = $ac->fetchrow_array) {
		for ($perm) {
			$cf{"perm_$action"} = "yes" if (/0/);
			$cf{"perm_$action"} = "yes" if (/1/ && exists $cf{uid});
			$cf{"perm_$action"} = "yes" if (/2/ && $cf{uid} == 0);
		}
	}
	getcgi("page");
	err("Invalid page: $cgi{page}") if
		($cgi{page} =~ /[^\w\/-]/ ||
		($cgi{page} && !-e "$cf{datapath}/intpages/doc/$cgi{page}.tmpl"));
	prthtml("doc/" . ($cgi{page} ? $cgi{page} : "index"))
}
elsif ($cgi{action} eq "passwd") {
	getcgi({
		password	=> "Password",
		confirm		=> "Confirmation pass",
	});
	err("Passwords do not match") if $cgi{password} ne $cgi{confirm};
	err("Password too short, please ensure it is at least 6 characters")
		if length($cgi{password}) < 6;
	my $hash = hash($cgi{password});
	my $ruid = $cf{uid} + 1;
	dosql(qq[update ap_users set password="$hash" where uid=$ruid]);
	setcookie("avspro=$ruid+$hash");
	$cf{done} = "Password changed successfully";
	printindex();
}
elsif ($cgi{action} eq "logout") {
	my $time = time();
	setcookie("avspro=x; expires=$time");
	prthtml("loggedout");
}
else {
	err("Invalid action: $cgi{action}");
}


#---------------------------------! subs !------------------------------------

sub	checksession {
	my $level = shift;
	my $cookie;
	if (($cookie = $ENV{COOKIE} || $ENV{HTTP_COOKIE}) =~ /^avspro=(.+?)(;.*)?$/) {
		($cookie = $1) =~ tr/+/ /;
		my ($id, $hash) = split(/\s+/, $cookie);
		$id = 0 if !$id;
		$ac = dosql(qq[select * from ap_users where uid="$id" and password="$hash"]);
		if ($ac->rows) {
			$cf{uid} = ($id - 1);
			if ($cf{uid} > 0 && $level > 1) {
				prthtml("authfailed");
				exit;
			}
		} elsif ($level > 0) {
			prthtml("authfailed");
			exit;
		}
	} elsif ($level > 0) {
		prthtml("authfailed");
		exit;
	}
}

sub	avsselect {
	my $selected = shift(@_);
	my $ac = dosql(qq[select id, name from ap_avs]);
	my $options = qq[\t<option value="">-\n];
	while (my $row = $ac->fetchrow_hashref) {
		$options .= qq[\t<option value="$$row{id}"].
			($selected eq $$row{id} ? " selected" : "").
			qq[>$$row{name}\n];
	}
	return $options;
}

sub	selectscheme {
	$cf{schemeselect} = "";
	my $ac = dosql(qq[select name from ap_schemes]);
	$cf{schemeselect} .= qq[\t\t<option value="$_">$_\n]
		while $_ = ($ac->fetchrow_array)[0];
	prthtml("editschemes/select");	                                                
}

sub	schemeindex {
	if ($cgi{scheme}) {
		my $ac = dosql(qq[select cats from ap_schemes where name="$cgi{scheme}"]);
		err("No such scheme: $cgi{scheme}") if !$ac->rows;
		my @ccats = split(/ /, ($ac->fetchrow_array)[0]);
		foreach (1..5) {
			$cf{"catselect_$_"} = catselect(shift @ccats);
		}
		foreach ("bodytags", "tabletags", "tdtags", "fonttags") {
			$cf{$_} = "";
			$ac = dosql(qq[select tag from ap_$_ where scheme="$cgi{scheme}"]);
			while (my $tag = ($ac->fetchrow_array)[0]) {
				$cf{$_} .= "$tag\n";
			}
		}
		$ac = dosql(qq[select fg, bg from ap_logogen where scheme="$cgi{scheme}"]);
		if ($ac->rows) {
			my $row = $ac->fetchrow_hashref;
			$cf{logofg} = $$row{fg};
			$cf{logobg} = $$row{bg};
		} else {
			@cf{"logofg", "logobg"} = ("", "");
		}
	} else {
		foreach (1..5) {
			$cf{"catselect_$_"} = catselect();
		}
		foreach ("bodytags", "tabletags", "tdtags", "fonttags", "logofg", "logobg") {
			$cf{$_} = "";
		}
	}
	prthtml("editschemes/edit");
}

sub	selecttemplatetype {
	my $ac = dosql(qq[select name from ap_pagetypes]);
	$cf{pagetypes} = "";
	$cf{pagetypes} .= "<option value=$_>$_\n"
		while $_ = ($ac->fetchrow_array)[0];
	$cf{modules} = qq[\t<option value="default">All (default)\n];
	$ac = dosql(qq[select id, name from ap_avs]);
	while (my $row = $ac->fetchrow_hashref) {
		$cf{modules} .= qq[\t<option value="$$row{id}">$$row{name}\n];
	}
	prthtml("edittemplate/selecttype");
}

sub	selecttemplate {
	$cf{templateselect} = "";
	if (opendir(D, "$cf{datapath}/templates/$cgi{dir}")) {
		foreach (grep { /\.(tmpl|s?html?)$/ } readdir(D)) {
			/^(\S+)\.(tmpl|s?html?)$/;
			my ($filename, $tmplname) = ($_, $1);
			$cf{templateselect} .= qq[\t\t<option value="$filename">$tmplname\n];
		}
		closedir(D);
	} else {
		mkdir_r("$cf{datapath}/templates/$cgi{dir}");
	}
	$cgi{mod} ||= "ANY";
	prthtml("edittemplate/selecttemplate");
}

sub	layoutindex {
	my $ac = dosql(qq[select name from ap_pagetypes]);
	$cf{pagetypes} = "";
	$cf{pagetypes} .= "$_\n"
		while $_ = ($ac->fetchrow_array)[0];
	$ac = dosql(qq[select name from ap_layouts]);
	$cf{layoutselect} .= qq[\t\t<option value="$_">$_\n]
		while $_ = ($ac->fetchrow_array)[0];
	prthtml("editlayouts/select");
}

sub	edittextlinks {
	$cf{catselect} = catselect();
	$cf{sponselect} = "";
	my $ac = dosql(qq[select id, name from ap_sponsors]);
	$cf{sponselect} .= qq[\t\t<option value="$$_{id}">$$_{name}\n]
		while $_ = $ac->fetchrow_hashref;
	prthtml("edittextlinks/select");
}

sub	viewsites {
	$cf{limit} = $cgi{num} || 10;
	my $query = "";
	if ($cgi{cat}) {
		$query = qq[where cat = "$cgi{cat}"]
	} else {
		$cf{cat} = "Any";
	}
	my %avs;
	my $ac = dosql(qq[select id,name from ap_avs]);
	$avs{$$_[0]} = $$_[1] while $_ = $ac->fetchrow_arrayref;
	if ($cgi{avs}) {
		$cf{avsname} = $avs{$cgi{avs}} or err("No such AVS ID: $cgi{avs}");
		my $findavs = join(" or ", map { qq[avs${_}_id = "$cgi{avs}"]} 1..8);
		$query = ($query ? qq[$query and ($findavs)] : qq[where ($findavs)]);
	} else {
		$cf{avsname} = "Any";
	}
	if ($cgi{domain}) {
		$query = ($query ? qq[$query and domain = "$cgi{domain}"] : qq[where domain = "$cgi{domain}"]);
	} else {
		$cf{domain} = "Any";
	}
	$ac = dosql(qq[select *, date_format(ctime, "%d %b %y") as cdate, concat("http://", domain, "/", dir) as url from ap_sites $query order by id desc limit $cf{limit}]);
	prthtml("viewsites/head");
	while (my $row = $ac->fetchrow_hashref) {
		map { $cf{$_} = $$row{$_} }
			("id", "cdate", "sitename", "cat", "memarea", "htmlext");
		foreach my $n (1..$$row{numavss}) {
			$cf{avs} = $avs{$$row{"avs${n}_id"}};
			$cf{url} = $$row{url} . "/" . $$row{"avs${n}_dir"};
			prthtml("viewsites/item");
		}
	}
	$cf{catselect} = catselect();
	$cf{avsselect} = avsselect();
	$ac = dosql(qq[select domain from ap_domains]);
	$cf{domainselect} = qq[\t<option value="">-\n];
	$cf{domainselect} .= qq[\t<option value="$_">$_\n]
		while $_ = ($ac->fetchrow_array)[0];
	prthtml("viewsites/foot");
}

sub	siteinfo {
	my $ac = dosql(qq[select *, date_format(ctime, "%H:%I, %d %b %y") as cdate, concat("http://", domain, "/", dir) as url from ap_sites where id="$cgi{id}"]);
	err("No such site ID: $cgi{id}") if !$ac->rows;
	%cgi = %{($ac->fetchrow_hashref)};

	my %avs;
	$ac = dosql(qq[select id,name from ap_avs]);
	$avs{$$_[0]} = $$_[1] while $_ = $ac->fetchrow_arrayref;
	$cf{avsvers} = "";
	foreach my $n (1..$cgi{numavss}) {
		my $avsname = $avs{$cgi{"avs${n}_id"}};
		my $acc = $cgi{"avs${n}_acc"};
		my $url = "$cgi{url}/" . $cgi{"avs${n}_dir"};
		my $siteid = $cgi{"avs${n}_siteid"};
		$cf{avsvers} .= qq[\t\t<il><a href="$url">$avsname</a> (<a href="$url/$cgi{memarea}">content</a>) - account <b>$acc</b>, site ID <b>$siteid</b></li>];
	}

	$ac = dosql(qq[select dir from ap_domains where domain="$cgi{domain}"]);        err("No such domain: $cgi{domain}") if !$ac->rows;
	err("No such domain: $cgi{domain}") if !$ac->rows;
	$cgi{rootdir} = ($ac->fetchrow_array)[0];
	my $dir = "$cgi{rootdir}/$cgi{dir}";
	err("Could not find site directory: $dir") if !-d $dir;

	$cf{dirindex} = prtdirindex($dir);
	prthtml("siteinfo");
}

sub	prtdirindex {
	my ($dir, $depth) = @_;
	my $tabs = ("\t" x ($depth + 1));
	my $out;
	(my $cdir = $dir) =~ s/^.*\/([^\/]+)$/$1/;
	opendir(D, "$dir") or err("Could not open directory: $dir");
	my @files = grep { !/^\.*$/ && !/\.(jpe?g|gif)$/i } readdir(D);
	foreach my $item (@files) {
		if (-d "$dir/$item") {
			$out .= prtdirindex("$dir/$item", ($depth + 1));
		} else {
			$item .= qq[ (<a href="$cf{cgiurl}?].
				urienc(qq[action=editfile&id=].
				qq[$cgi{id}&file=$dir/$item]) .
				qq[">edit</a>)];
			$out .= "$tabs<li>$item</li>\n";
		}
	}
	return  ($depth > 1 ? "$tabs<li>$cdir</li>\n" : "") .
		($out ? "$tabs<ul>\n" . $out . "$tabs</ul>\n" : "");
}

sub	redir {
	my $action = shift or return;
	print "Location: $cf{cgiurl}?action=$action\n";
	inithtml();
	exit;
}

sub	printindex {
	my $ac = dosql(qq[select count(*) from ap_sites]);
	$cf{totalsitecount} = ($ac->fetchrow_array)[0] || 0;
	$ac = dosql(qq[select count(*) from ap_sites where date_format(ctime, "%Y-%m-%d") = curdate()]);
	$cf{todaysitecount} = ($ac->fetchrow_array)[0] || 0;
	$ac = dosql(qq[select cat,count(*) as num from ap_sites group by cat order by cat]);
	$cf{catlist} = "";
	while (my $row = $ac->fetchrow_hashref) {
		$cf{catlist} .= qq[\t$$row{cat}: <b>$$row{num}</b>\n];
	}
	$ac = dosql(qq[select sitename, domain, dir, memarea from ap_sites order by id desc limit 10]);
	$cf{recentsites} = "";
	while (my $row = $ac->fetchrow_hashref) {
		$cf{recentsites} .= qq[\t<a href="http://$$row{domain}/$$row{dir}/">$$row{sitename}</a><br>\n];
	}
	
	prthtml("index");
}

sub	initvars {
	$cf{cgiurl} = "http://$ENV{HTTP_HOST}$ENV{SCRIPT_NAME}" if !$cf{cgiurl};
	err("Could not find avspro.pl") if !-e "$cf{datapath}/avspro.pl";
	@corefuncs = qw(
		quickgen
		sitegen
		deltestsites
		refreshimgqueue
		selectscheme
		editlayouts
		selecttemplatetype
		edithtmlext
		editcats
		imagetypes
		editnames
		editheaders
		editdescr
		editparagraphs
		editkeywords
		editdomainlist
		editdirlist
		editavsdirs
		edithtaccess
		quicksponsors
		edittextlinks
		editsubs
		editaccounts
		assigncatselect
		editfreehosts
		viewsites
		editusers
		editperms
		gensetup
		edittimers
		listpacks
		updatescript
		doc
	);
	%opts = (
		remsitenames	=> 0,
		remheaders	=> 0,
		remdescrs	=> 0,
		remparagraphs	=> 0,
		uselogogen	=> 0,
		usehtaccess	=> 0,
		usesymlinks	=> 0,
		usefreehosts	=> 0,
		quietsched	=> 0,
		numkeywords	=> 1,
		defcols		=> 1,
		defrows		=> 1,
		defthumbx	=> 1,
		defthumby	=> 1,
		numlinks	=> 1,
		lsgtime		=> 1,
		imagepath	=> 1,
		searchurl	=> 1,
		searchscheme	=> 1,
	);
}
